

package.path  = package.path..";.\\LuaSocket\\?.lua;"
package.cpath = package.cpath..";.\\LuaSocket\\?.dll;"
--local initconnection = require("debugger")
--initconnection("127.0.0.1",10000,"dcsserver",nil,"win", "")

local tupps = {}

local main_dir = lfs.writedir()  .. [[tuppersVAPlugin\]]
lfs.mkdir(main_dir)  -- create directories, should not over-write current.

local JSON = loadfile("Scripts\\JSON.lua")()

 local _update = nil
 local radios = nil
 local adf  = nil
 local mi8 = nil

local _prevExport = {}
_prevExport.LuaExportActivityNextEvent = LuaExportActivityNextEvent
_prevExport.LuaExportBeforeNextFrame = LuaExportBeforeNextFrame
_prevExport.LuaExportStop           = LuaExportStop


function tupps.getSelectorPosition(_args,_step)
    local _value = GetDevice(0):get_argument_value(_args)
    local _num = math.abs(tonumber(string.format("%.0f", (_value) / _step)))

    return _num

end
function tupps.round(number, step)
    if number == 0 then
        return 0
    else
        return math.floor((number + step / 2) / step) * step
    end
end
function tupps.getRadioFrequency(_deviceId, _roundTo)
    local _device = GetDevice(_deviceId)

    if not _roundTo then
        _roundTo = 5000
    end


    if _device then
        if _device:is_on() then
            -- round as the numbers arent exact
            return tupps.round(_device:get_frequency(),_roundTo)
        end
    end
    return 1
end

function tupps._exportUh1h(_data)

    _data.radios[1].name = "AN/ARC-131"
    _data.radios[1].freq = tupps.getRadioFrequency(23)
    if _data.radios[1].freq == 1 then
      _data.radios[1].freq = 0;
      _data.radios[1].on = false;  
    else
    
    _data.radios[1].freq =_data.radios[1].freq / 1000000
    _data.radios[1].on = true;
    end
    
    
    
    
    _data.radios[2].name = "AN/ARC-51BX - UHF"
    _data.radios[2].freq = tupps.getRadioFrequency(22) / 1000000

     -- get channel selector
    local _selector = tupps.getSelectorPosition(15, 0.1)

    if _selector < 1 then
        _data.radios[2].channel = tupps.getSelectorPosition(16, 0.05) + 1 --add 1 as channel 0 is channel 1
    elseif  _selector > 1 then
      _data.radios[2].freq = 2
    end
    
    local uhfModeKnob = tupps.getSelectorPosition(17, 0.1)
    if uhfModeKnob == 2 and _data.radios[2].freq > 1000 then
        _data.radios[2].freq = 3
    end
    
    
    _data.radios[3].name = "AN/ARC-134"
    _data.radios[3].freq = tupps.getRadioFrequency(20)
    
   _data.adf.adffreq[1].freq =  GetDevice(0):get_argument_value(45)
   
    local adfselector =  GetDevice(0):get_argument_value(38)
    local start 
    local total
   if adfselector ==  -1 then
        if _data.adf.adffreq[1].freq < 0.05 then
   
        _data.adf.adffreq[1].freq = (_data.adf.adffreq[1].freq * 100 / 0.05) / 100 * 1 +19   -- *1 Makes no sense but need to have it there to remind me how bad I'm in math.. 
   
          else
    
        _data.adf.adffreq[1].freq = ((_data.adf.adffreq[1].freq - 0.05) * 100 / 0.5)  * 20 / 100 + 20   -- *1 Makes no sense but need to have it there to remind me how bad I'm in math..
      
      end
      
   elseif adfselector == 0 then
     
      if _data.adf.adffreq[1].freq < 0.115 then
   
        _data.adf.adffreq[1].freq = (_data.adf.adffreq[1].freq * 100 / 0.115) / 100 * 5 + 40   -- *1 Makes no sense but need to have it there to remind me how bad I'm in math.. 
      else
      
        _data.adf.adffreq[1].freq = ((_data.adf.adffreq[1].freq - 0.115) * 100 / 0.435)  * 40 / 100 + 45
     
     end
    
   else
     if _data.adf.adffreq[1].freq < 0.06 then
   
        _data.adf.adffreq[1].freq = (_data.adf.adffreq[1].freq * 100 / 0.06) / 100 * 5 + 85   -- *1 Makes no sense but need to have it there to remind me how bad I'm in math.. 
   
          else
    
        _data.adf.adffreq[1].freq = ((_data.adf.adffreq[1].freq - 0.06) * 100 / 0.49)  * 90 / 100 + 90   -- *1 Makes no sense but need to have it there to remind me how bad I'm in math..
      
      end
    
   
   end 
   
 
   _data.adf.adffreq[1].freq =  tonumber(string.format("%.0f", _data.adf.adffreq[1].freq *10))
   _data.adf.selector = tupps.getSelectorPosition(43, 0.1)
   _data.adf.signal  =  GetDevice(0):get_argument_value(40) 
    _data.adf.signal  = tonumber(string.format("%.0f", _data.adf.signal * 100 ))
   if tupps.getSelectorPosition(43, 0.1) == 1 then
    _data.adf.ison = true
   else
    _data.adf.ison = false
   end
    
    return _data
    
end

function tupps.exportRadioSa342(_data)

    _data.radios[1].name = "TRAP 138A"
  
    
    if  tupps.getSelectorPosition(128, 0.33) == 1 then
      _data.radios[1].on = true
      _data.radios[1].freq = tupps.getRadioFrequency(5)
      _data.radios[1].freq  = _data.radios[1].freq  / 1000000
      
    else
      _data.radios[1].on = false
    end
    
     _data.radios[2].name = "UHF TRA 6031"

    -- deal with odd radio tune & rounding issue... BUG you cannot set frequency 243.000 ever again
    local freq = tupps.getRadioFrequency(31, 500)
    freq = (math.floor(freq / 1000) * 1000)

    _data.radios[2].freq = freq  / 1000000
    
    if tupps.getSelectorPosition(383, 0.167) == 0 then
        _data.radios[2].on = false
     else
        _data.radios[2].on = true
    end
    
    _data.radios[3].name = "TRC 9600 PR4G"
    _data.radios[3].freq = tupps.getRadioFrequency(28)
    _data.radios[3].freq  = _data.radios[3].freq  / 1000000
    _data.radios[3].channel = tupps.getSelectorPosition(273, 0.143) + 1
    
    if tupps.getSelectorPosition(272, 0.25) == 1 then
        _data.radios[3].on = true
     else
        _data.radios[3].on = false
    end
    
    -- ADF  -- DEVICE 21
    --HUNDREDS BUTTON 5
    -- Ten    BUTTON 6, 
   --  Unit,  Button_7
    _data.adf.selector = tupps.getSelectorPosition(178, 0.33)
    if _data.adf.selector == 2 then
        _data.adf.ison = true
    else
        _data.adf.ison = false
    end
    
    _data.adf.selected =  GetDevice(0):get_argument_value(166)
        
    local stringFreq = tupps.getSelectorPosition(158, 0.1) .. tupps.getSelectorPosition(159, 0.1) .. tupps.getSelectorPosition(160, 0.1) .. "." .. tupps.getSelectorPosition(161, 0.1)
    
    
    _data.adf.adffreq[1].freq =  tonumber(stringFreq)
    
    stringFreq = tupps.getSelectorPosition(162, 0.1) .. tupps.getSelectorPosition(163, 0.1) .. tupps.getSelectorPosition(164, 0.1) .. "." .. tupps.getSelectorPosition(165, 0.1)
     
     _data.adf.adffreq[2].freq =  tonumber(stringFreq)
    
  --[[    ADF_leftcent=158,
  ADF_leftdix=159,
  ADF_leftunit=160,
  ADF_leftdec=161,
  ADF_rightcent=162,
  ADF_rightdix=163,
  ADF_rightunit=164,
  ADF_rightdec=165,
    ]]--
    
    
    
    return _data
    
end
function tupps.exportRadioMI8(_data)

    _data.radios[1].name = "R-863"
    _data.radios[1].freq = tupps.getRadioFrequency(38)
    _data.radios[1].freq  = _data.radios[1].freq / 1000000
    
    local gunners =  GetDevice(0):get_argument_value(12)
    
    _data.radios[2].name = "JADRO-1A"
    _data.radios[2].freq = tupps.getRadioFrequency(37,500)


    _data.radios[3].name = "R-828"
    _data.radios[3].freq = tupps.getRadioFrequency(39,50000)
    _data.radios[3].channel = tupps.getSelectorPosition(735, 0.1) + 1

    -- Get selected radio from SPU-9
    local _switch = tupps.getSelectorPosition(550,0.1)

    if _switch == 0 then
        _data.selected = 1
    elseif _switch == 1 then
        _data.selected = 2
    elseif _switch == 2 then
        _data.selected = 3
    else
        _data.selected = -1
    end
    
    
    

    _data.adf.selector = tupps.getSelectorPosition(446, 0.1)
    if _data.adf.selector == 1 then
        _data.adf.ison = true
    else
        _data.adf.ison = false
    end
    
    _data.adf.selected =  GetDevice(0):get_argument_value(469)
    local string2 = tupps.getSelectorPosition(452, 0.1) *10 + tonumber(string.format("%.0f",GetDevice(0):get_argument_value(451) * 20 / 0.4))
    if string2 < 10 then 
      string2 = "0" .. string2
    end        
    local stringFreq = tupps.getSelectorPosition(678, 0.05) + 1 .. string2  

    _data.adf.adffreq[2].freq =  tonumber(stringFreq)
   
    string2 = tupps.getSelectorPosition(450, 0.1) *10 +   tonumber(string.format("%.0f",GetDevice(0):get_argument_value(449) * 20 / 0.4)) 
    if string2 < 10 then 
      string2 = "0" .. string2
    end
    stringFreq = tupps.getSelectorPosition(675, 0.05) + 1 .. string2  
        
    
    _data.adf.adffreq[1].freq =  tonumber(stringFreq)
    
    _data.adf.signal = GetDevice(0):get_argument_value(681) 
    _data.adf.signal  = tonumber(string.format("%.0f", _data.adf.signal * 100 ))
    
    
    
    _data.mi8.esbrSelector = tupps.getSelectorPosition(730, 0.0555)
    _data.mi8.podvariant =  tupps.getSelectorPosition(719, 0.1)
    


    return _data

end




LuaExportActivityNextEvent = function(tCurrent)
 
  local tNext = tCurrent + 0.1
  local _data = LoGetSelfData()
  
  if _data ~= nil then
    _update  =
    {
      unit = "",
      selected = 1,
      radios =
      {
        { name = "", freq = 0, channel = 0, on = false },
        { name = "", freq = 0, channel = 0, on = false },
        { name = "", freq = 0, channel = 0, on = false },
      },
      adf =
      {
          ison = false,
          selector = 0,
          signal = 0,
          selected = 1,
          adffreq ={ { freq = 0 },
                     { freq = 0 },
                   }
      },
      mi8 = {
          esbrSelector = 0,
          podvariant = 0
      
      }
      
    }
 
    _update.unit = _data.Name
    local updateflg = false
    if _update.unit == "Mi-8MT" then
      _update = tupps.exportRadioMI8(_update)
    elseif string.find(_update.unit, "SA342") then
      _update = tupps.exportRadioSa342(_update)
    elseif _update.unit == "UH-1H" then
      _update =  tupps._exportUh1h(_update) 
    else  
      
    end
   
      if radios == nil or adf == nil or mi8 == nil then
        updateflg = true
      end  
      
      if radios ~= nil then
        if radios[1].freq ~= _update.radios[1].freq then
           updateflg = true
        end
        if radios[2].freq ~= _update.radios[2].freq then
           updateflg = true
        end
        if radios[3].freq ~= _update.radios[3].freq then
           updateflg = true
        end
        if radios[3].channel ~= _update.radios[3].channel then
           updateflg = true
        end
        if radios[2].channel ~= _update.radios[2].channel then
           updateflg = true
        end
      end
      if adf ~= nil then
        if adf.adffreq[1].freq ~= _update.adf.adffreq[1].freq then
          updateflg = true
        end
         if adf.adffreq[2].freq ~= _update.adf.adffreq[2].freq then
          updateflg = true
        end
        if adf.ison ~= _update.adf.ison then
          updateflg = true
        end
        if adf.selector ~= _update.adf.selector then
          updateflg = true
        end 
        if adf.signal ~= _update.adf.signal then
          updateflg = true
        end
         if adf.selected ~= _update.adf.selected then
          updateflg = true
        end
        if mi8 ~= nil then
            if mi8.esbrSelector ~= _update.mi8.esbrSelector then
              updateflg = true
            end
            if mi8.podvariant ~= _update.mi8.podvariant then
              updateflg = true
            end
        end
        
      end

   
    if updateflg  then
         
          local raw_json_text    = JSON:encode(_update)
          radios = _update.radios
          adf = _update.adf
          mi8 = _update.mi8
     
          local  exportFileName = main_dir ..  [[export.json]]
          local exportFile = io.open(exportFileName, 'w')
          exportFile:write(raw_json_text)    
          exportFile:close()
     end
   end

   local _status, _result = pcall(function()
        -- Call original function if it exists
        if _prevExport.LuaExportActivityNextEvent then
            _prevExport.LuaExportActivityNextEvent(tCurrent)
        end

    end)

  return tNext
end

function tupps._rotary( _device , _arg_number, _button, _step, _direction )
  local value = GetDevice(0):get_argument_value(_arg_number)
  local newval = value + (_step * _direction)
  GetDevice(_device):performClickableAction(3000 + _button, newval)
end

function tupps._radioWheel( _device , _button, _step, _direction )
    
    local val = _step * _direction 
    GetDevice(_device):performClickableAction(3000 + _button, val)

end

function tupps._button(_device_id, _command, _value)

  GetDevice(_device_id):performClickableAction(3000 +_command, _value)

end

function tupps._momentary(_device_id, _command)

  GetDevice(_device_id):performClickableAction(3000 +_command, 1)
  
  GetDevice(_device_id):performClickableAction(3000 +_command, 0)
  
end

LuaExportBeforeNextFrame = function()
  local _filename = main_dir .. [[import.json]]
  local _importFile = io.open( _filename, 'r')
  if _importFile then
        local fileContent = _importFile:read('*all')
        _importFile:close()
        _importFile = nil
        if fileContent ~= "" then
          
          local input = JSON:decode(fileContent) -- decoded

          if string.match(input.type,"ROTARY") then
              tupps._rotary(input.device, input.arg_number, input.command, input.step, input.value)  
          end
          
          if string.match(input.type,"BUTTON") then
              tupps._button(input.device, input.command, input.value)
              
          end
           if string.match(input.type,"MOMENTARY") then
              tupps._momentary(input.device, input.command)
              
          end
          if string.match(input.type,"RADIO") then
              tupps._radioWheel(input.device, input.command,  input.step, input.value)
          end
            
          
          
          local importFile = io.open(_filename, 'w')
          importFile:write("")    
          importFile:close()
        end
        
        
  end



  _status, _result = pcall(function()
        -- Call original function if it exists
        if _prevExport.LuaExportBeforeNextFrame then
            _prevExport.LuaExportBeforeNextFrame()
        end
    end)

    if not _status then
        
    end

end


LuaExportStop   = function()

  local  exportFileName = main_dir ..  [[export.json]]
 --[[ local exportFile = io.open(exportFileName, 'w')
  exportFile:write("")    
  exportFile:close()]]--


 _status, _result = pcall(function()
        -- Call original function if it exists
        if _prevExport.LuaExportStop then
           _prevExport.LuaExportStop()
        end
    end)

    if not _status then
        
    end

end


